<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; color: #333; }
        .receipt-header { text-align: center; border-bottom: 2px solid #333; padding-bottom: 10px; margin-bottom: 15px; }
        .receipt-title { font-size: 18px; font-weight: 700; text-transform: uppercase; }
        .receipt-meta { font-size: 12px; color: #555; margin-top: 5px; }
        .receipt-table { width: 100%; border-collapse: collapse; margin: 10px 0; }
        .receipt-table th, .receipt-table td { padding: 6px 10px; text-align: left; border-bottom: 1px solid #dee2e6; }
        .receipt-table th { font-weight: 600; width: 40%; color: #495057; }
        .amount-words { font-style: italic; padding: 8px; background: #f8f9fa; }
        .receipt-footer { margin-top: 20px; text-align: center; font-size: 11px; color: #6c757d; }
    </style>
</head>
<body>
<div class="receipt">
    <div class="receipt-header">
        <div class="receipt-title">{{ config('student_registration.hostel_name', config('app.name')) }}</div>
        <div class="receipt-meta">Deposit Receipt</div>
    </div>
    <table class="receipt-table">
        <tr><th>Transaction / Receipt</th><td>D-{{ $deposit->id }}</td></tr>
        <tr><th>Date</th><td>{{ $deposit->actual_deposit_date?->format('d/m/Y') ?? '—' }}</td></tr>
        <tr><th>Student ID</th><td>{{ $deposit->student_id }}</td></tr>
        <tr><th>Student Name</th><td>{{ $deposit->student->full_name ?? '—' }}</td></tr>
        @if($deposit->student && ($deposit->student->room_bed_identifier || $deposit->student->bed))
            <tr><th>Room / Bed</th><td>{{ $deposit->student->room_bed_identifier ?? ($deposit->student->bed ? $deposit->student->bed->name ?? '—' : '—') }}</td></tr>
        @endif
        <tr><th>Period</th><td>{{ $deposit->from_date?->format('d/m/Y') ?? '—' }} to {{ $deposit->to_date?->format('d/m/Y') ?? '—' }}</td></tr>
        <tr><th>Amount (₹)</th><td>{{ number_format($deposit->amount, 2) }}</td></tr>
        <tr><th>Amount in Words</th><td><div class="amount-words">{{ $amountInWords ?? '—' }}</div></td></tr>
        <tr><th>Payment Mode</th><td>{{ \Illuminate\Support\Arr::get(config('student_registration.payment_modes', []), $deposit->payment_mode, $deposit->payment_mode) }}</td></tr>
        @if($deposit->transaction_id)<tr><th>UTR / Transaction ID</th><td>{{ $deposit->transaction_id }}</td></tr>@endif
    </table>
    <div class="receipt-footer">This is a computer-generated receipt. Security deposit received.</div>
</div>
</body>
</html>
