<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; color: #333; }
        .receipt { max-width: 100%; }
        .receipt-header { text-align: center; border-bottom: 2px solid #333; padding-bottom: 10px; margin-bottom: 15px; }
        .receipt-title { font-size: 18px; font-weight: 700; text-transform: uppercase; }
        .receipt-meta { font-size: 12px; color: #555; margin-top: 5px; }
        .receipt-table { width: 100%; border-collapse: collapse; margin: 10px 0; }
        .receipt-table th, .receipt-table td { padding: 6px 10px; text-align: left; border-bottom: 1px solid #dee2e6; }
        .receipt-table th { font-weight: 600; width: 40%; color: #495057; }
        .amount-words { font-style: italic; padding: 8px; background: #f8f9fa; }
        .receipt-footer { margin-top: 20px; text-align: center; font-size: 11px; color: #6c757d; }
    </style>
</head>
<body>
<div class="receipt">
    <div class="receipt-header">
        <div class="receipt-title">{{ config('student_registration.hostel_name', config('app.name')) }}</div>
        <div class="receipt-meta">Rent Receipt</div>
    </div>
    <table class="receipt-table">
        <tr><th>Receipt No.</th><td>{{ $rent->receipt_no ?? 'R' . $rent->id }}</td></tr>
        <tr><th>Date</th><td>{{ $rent->paid_at ? $rent->paid_at->format('d/m/Y') : '—' }}</td></tr>
        <tr><th>Student ID</th><td>{{ $rent->student_id }}</td></tr>
        <tr><th>Student Name</th><td>{{ $rent->student->full_name ?? '—' }}</td></tr>
        @if($rent->student && ($rent->student->room_bed_identifier || $rent->student->bed))
            <tr><th>Room / Bed</th><td>{{ $rent->student->room_bed_identifier ?? ($rent->student->bed ? $rent->student->bed->name ?? '—' : '—') }}</td></tr>
        @endif
        <tr><th>Period</th><td>{{ $rent->period_from->format('d/m/Y') }} to {{ $rent->period_to->format('d/m/Y') }}</td></tr>
        <tr><th>Amount (₹)</th><td>{{ number_format($rent->amount, 2) }}</td></tr>
        <tr><th>Amount in Words</th><td><div class="amount-words">{{ $amountInWords ?? '—' }}</div></td></tr>
        <tr><th>Payment Mode</th><td>{{ \Illuminate\Support\Arr::get(config('student_registration.payment_modes', []), $rent->payment_mode, $rent->payment_mode) }}</td></tr>
        @if($rent->transaction_id)<tr><th>UTR / Transaction ID</th><td>{{ $rent->transaction_id }}</td></tr>@endif
        @if($rent->cheque_number)<tr><th>Cheque Number</th><td>{{ $rent->cheque_number }}</td></tr>@endif
    </table>
    <div class="receipt-footer">This is a computer-generated receipt. Thank you for your payment.</div>
</div>
</body>
</html>
