<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\Auth\LoginController as AdminLoginController;
use App\Http\Controllers\Admin\Auth\VerifyOtpController as AdminVerifyOtpController;
use App\Http\Controllers\Admin\FloorController;
use App\Http\Controllers\Admin\RoomController;
use App\Http\Controllers\Admin\BedController;
use App\Http\Controllers\Admin\StudentRegistrationController;
use App\Http\Controllers\Admin\StudentRegistrationApiController;
use App\Http\Controllers\Admin\DepositController;
use App\Http\Controllers\Admin\RentController;
use App\Http\Controllers\Admin\AgreementController;
use App\Http\Controllers\Admin\PoliceRecordController;
use App\Http\Controllers\Admin\LeaveController;
use App\Http\Controllers\Admin\ReceiptBookController;
use App\Http\Controllers\Admin\ExpenseController;
use App\Http\Controllers\Admin\ExpenseHeadController;
use App\Http\Controllers\Admin\StudentSwitchController;
use App\Http\Controllers\Admin\BankDepositController;
use App\Http\Controllers\Admin\DrawingController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\EnquiryController;
use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\Admin\HostelController;
use App\Http\Controllers\Admin\WebsiteController;
use App\Http\Controllers\Admin\NotificationController;
use App\Http\Controllers\Admin\MenuManagementController as AdminMenuManagementController;
use App\Http\Controllers\Admin\PdfController;

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
| All admin panel routes. Loaded with prefix 'admin' and name prefix 'admin.'
| from bootstrap/app.php.
*/

// Login (controller redirects if already authenticated)
Route::get('/login', [AdminLoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AdminLoginController::class, 'login'])->middleware('throttle:5,1');

// Auth required but OTP not yet verified: verify OTP & resend
Route::middleware('auth:admin')->group(function () {
    Route::get('/verify-otp', [AdminVerifyOtpController::class, 'showVerifyForm'])->name('verify-otp');
    Route::post('/verify-otp', [AdminVerifyOtpController::class, 'verify']);
    Route::post('/resend-otp', [AdminVerifyOtpController::class, 'resend'])->name('resend-otp');
    Route::post('/logout', [AdminLoginController::class, 'logout'])->name('logout');
});

// Protected admin routes: auth → OTP verified (no-cache so back button redirects to login)
Route::middleware(['auth.admin', 'otp.verified:admin', 'prevent.back.history'])->group(function () {
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/dashboard/stats', [DashboardController::class, 'stats'])->name('dashboard.stats');

    // Admin profile & change password
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::match(['put', 'patch'], '/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::get('/profile/change-password', [ProfileController::class, 'showChangePasswordForm'])->name('profile.change-password');
    Route::post('/profile/change-password', [ProfileController::class, 'updatePassword'])->name('profile.password.update');

    // Notifications
    Route::get('/notifications', [NotificationController::class, 'index'])->name('notifications.index');
    Route::match(['get', 'post'], '/notifications/data', [NotificationController::class, 'getData'])->name('notifications.data');
    Route::get('/notifications/dropdown', [NotificationController::class, 'dropdown'])->name('notifications.dropdown');
    Route::post('/notifications/{id}/mark-as-read', [NotificationController::class, 'markAsRead'])->name('notifications.markAsRead');
    Route::post('/notifications/mark-all-as-read', [NotificationController::class, 'markAllAsRead'])->name('notifications.markAllAsRead');
    Route::post('/notifications/sync', [NotificationController::class, 'sync'])->name('notifications.sync');

// Master - floors, rooms, beds
Route::get('/floors', [FloorController::class, 'index'])->name('floors.index');
Route::get('/floors/create', [FloorController::class, 'create'])->name('floors.create');
Route::post('/floors', [FloorController::class, 'store'])->name('floors.store');
Route::get('/floors/{floor}', [FloorController::class, 'show'])->name('floors.show');
Route::get('/floors/{floor}/edit', [FloorController::class, 'edit'])->name('floors.edit');
Route::match(['put', 'patch'], '/floors/{floor}', [FloorController::class, 'update'])->name('floors.update');
Route::delete('/floors/{floor}', [FloorController::class, 'destroy'])->name('floors.destroy');
Route::get('/rooms', [RoomController::class, 'index'])->name('rooms.index');
Route::get('/rooms/create', [RoomController::class, 'create'])->name('rooms.create');
Route::post('/rooms', [RoomController::class, 'store'])->name('rooms.store');
Route::get('/rooms/{room}', [RoomController::class, 'show'])->name('rooms.show');
Route::get('/rooms/{room}/edit', [RoomController::class, 'edit'])->name('rooms.edit');
Route::match(['put', 'patch'], '/rooms/{room}', [RoomController::class, 'update'])->name('rooms.update');
Route::delete('/rooms/{room}', [RoomController::class, 'destroy'])->name('rooms.destroy');
Route::get('/beds', [BedController::class, 'index'])->name('beds.index');
Route::get('/beds/create', [BedController::class, 'create'])->name('beds.create');
Route::post('/beds', [BedController::class, 'store'])->name('beds.store');
Route::get('/beds/{bed}', [BedController::class, 'show'])->name('beds.show');
Route::get('/beds/{bed}/edit', [BedController::class, 'edit'])->name('beds.edit');
Route::match(['put', 'patch'], '/beds/{bed}', [BedController::class, 'update'])->name('beds.update');
Route::delete('/beds/{bed}', [BedController::class, 'destroy'])->name('beds.destroy');

// Students - Registration (multi-step)
Route::get('/students', [StudentRegistrationController::class, 'index'])->name('students.index');
Route::get('/students/data', [StudentRegistrationController::class, 'data'])->name('students.data');
Route::get('/students/export', [StudentRegistrationController::class, 'export'])->name('students.export');
Route::get('/students/registration/create', [StudentRegistrationController::class, 'create'])->name('students.registration.create');
Route::post('/students/registration', [StudentRegistrationController::class, 'storeStep1'])->name('students.registration.storeStep1');
Route::get('/students/registration/{student}/step/2', [StudentRegistrationController::class, 'step2'])->name('students.registration.step2');
Route::post('/students/registration/{student}/step/2', [StudentRegistrationController::class, 'storeStep2'])->name('students.registration.storeStep2');
Route::get('/students/registration/{student}/step/3', [StudentRegistrationController::class, 'step3'])->name('students.registration.step3');
Route::post('/students/registration/{student}/step/3', [StudentRegistrationController::class, 'storeStep3'])->name('students.registration.storeStep3');
Route::get('/students/registration/{student}/step/4', [StudentRegistrationController::class, 'step4'])->name('students.registration.step4');
Route::post('/students/registration/{student}/step/4', [StudentRegistrationController::class, 'storeStep4'])->name('students.registration.storeStep4');
Route::get('/students/registration/{student}/step/5', [StudentRegistrationController::class, 'step5'])->name('students.registration.step5');
Route::post('/students/registration/{student}/step/5', [StudentRegistrationController::class, 'storeStep5'])->name('students.registration.storeStep5');
Route::get('/students/api/floors', [StudentRegistrationApiController::class, 'floors'])->name('students.api.floors');
Route::get('/students/api/floors/{floor}/rooms', [StudentRegistrationApiController::class, 'rooms'])->name('students.api.rooms');
Route::get('/students/api/rooms/{room}/beds', [StudentRegistrationApiController::class, 'beds'])->name('students.api.beds');
Route::get('/students/switch', [StudentSwitchController::class, 'index'])->name('students.switch');
Route::post('/students/switch', [StudentSwitchController::class, 'store'])->name('students.switch.store');
Route::get('/students/{student}', [StudentRegistrationController::class, 'show'])->name('students.show');
Route::get('/students/{student}/edit', [StudentRegistrationController::class, 'edit'])->name('students.edit');
Route::match(['put', 'patch'], '/students/{student}', [StudentRegistrationController::class, 'update'])->name('students.update');
Route::post('/students/{student}/release', [StudentRegistrationController::class, 'release'])->name('students.release');
Route::get('/deposits', [DepositController::class, 'index'])->name('deposits.create');
Route::get('/deposits/add', [DepositController::class, 'create'])->name('deposits.add');
Route::post('/deposits', [DepositController::class, 'store'])->name('deposits.store');
Route::get('/deposits/return/{student}', [DepositController::class, 'returnForm'])->name('deposits.return');
Route::post('/deposits/return', [DepositController::class, 'storeReturn'])->name('deposits.return.store');
Route::get('/rents', [RentController::class, 'index'])->name('rents.index');
Route::get('/rents/create', [RentController::class, 'create'])->name('rents.create');
Route::post('/rents', [RentController::class, 'store'])->name('rents.store');
Route::get('/rents/{rent}/receipt', [RentController::class, 'receipt'])->name('rents.receipt');
Route::get('/rents/{rent}/pdf', [PdfController::class, 'rentReceipt'])->name('rents.receipt.pdf');
Route::get('/agreements', [AgreementController::class, 'index'])->name('agreements.index');
Route::get('/agreements/view/{student}', [AgreementController::class, 'view'])->name('agreements.view');
Route::get('/agreements/{student}/pdf', [PdfController::class, 'agreement'])->name('agreements.pdf');
Route::get('/agreements/renew/{student}', [AgreementController::class, 'renew'])->name('agreements.renew');
Route::post('/agreements/renew/{student}', [AgreementController::class, 'storeRenewal'])->name('agreements.renew.store');
Route::post('/agreements/remark', [AgreementController::class, 'storeRemark'])->name('agreements.remark.store');
Route::get('/police-records', [PoliceRecordController::class, 'index'])->name('police-records.index');
Route::get('/police-records/form/{student}', [PoliceRecordController::class, 'form'])->name('police-records.form');
Route::get('/leaves', [LeaveController::class, 'index'])->name('leaves.index');
Route::get('/leaves/create', [LeaveController::class, 'create'])->name('leaves.create');
Route::post('/leaves', [LeaveController::class, 'store'])->name('leaves.store');
Route::post('/leaves/{leave}/approve', [LeaveController::class, 'approve'])->name('leaves.approve');
Route::post('/leaves/{leave}/cancel', [LeaveController::class, 'cancel'])->name('leaves.cancel');
Route::post('/leaves/{leave}/return', [LeaveController::class, 'storeReturn'])->name('leaves.return.store');

// Expenses
Route::get('/expenses', [ExpenseController::class, 'index'])->name('expenses.index');
Route::post('/expenses', [ExpenseController::class, 'store'])->name('expenses.store');
Route::get('/expenses/balance', [ExpenseController::class, 'balance'])->name('expenses.balance');
Route::get('/expense-heads/create', [ExpenseHeadController::class, 'create'])->name('expense-heads.create');
Route::post('/expense-heads', [ExpenseHeadController::class, 'store'])->name('expense-heads.store');

// Reports
Route::get('/reports', [ReportController::class, 'index'])->name('reports.index');
Route::get('/reports/period', [ReportController::class, 'period'])->name('reports.period');

// Enquiry
Route::get('/enquiries', [EnquiryController::class, 'index'])->name('enquiries.index');
Route::post('/enquiries', [EnquiryController::class, 'store'])->name('enquiries.store');
Route::post('/enquiries/{enquiry}/check', [EnquiryController::class, 'check'])->name('enquiries.check');
Route::post('/enquiries/{enquiry}/remark', [EnquiryController::class, 'storeRemark'])->name('enquiries.remark.store');
Route::delete('/enquiries/{enquiry}', [EnquiryController::class, 'destroy'])->name('enquiries.destroy');

// Receipt Book
Route::get('/receipts/rent', [ReceiptBookController::class, 'rent'])->name('receipts.rent');
Route::get('/receipts/deposit', [ReceiptBookController::class, 'deposit'])->name('receipts.deposit');
Route::get('/receipts/deposit/{deposit}/print', [DepositController::class, 'receipt'])->name('receipts.deposit.print');
Route::get('/receipts/deposit-return', [ReceiptBookController::class, 'depositReturn'])->name('receipts.deposit-return');
Route::get('/receipts/deposit-return/{depositReturn}/print', [DepositController::class, 'returnReceipt'])->name('receipts.deposit-return.print');
Route::get('/receipts/deposit/{deposit}/pdf', [PdfController::class, 'depositReceipt'])->name('receipts.deposit.pdf');
Route::get('/receipts/deposit-return/{depositReturn}/pdf', [PdfController::class, 'depositReturnReceipt'])->name('receipts.deposit-return.pdf');
Route::post('/share/send-email', [PdfController::class, 'sendEmail'])->name('share.send-email');

// Bank Deposit (deposit to bank / withdraw from bank)
Route::get('/bank-deposits', [BankDepositController::class, 'index'])->name('bank-deposits.index');
Route::post('/bank-deposits', [BankDepositController::class, 'store'])->name('bank-deposits.store');

// Drawing (owner/admin credit/debit)
Route::get('/drawings', [DrawingController::class, 'index'])->name('drawings.index');
Route::post('/drawings', [DrawingController::class, 'store'])->name('drawings.store');

    // Hostel Settings
    Route::get('/hostel', [HostelController::class, 'edit'])->name('hostel.edit');
    Route::match(['put', 'patch'], '/hostel', [HostelController::class, 'update'])->name('hostel.update');

    // Website Management
    Route::prefix('website')->name('website.')->group(function () {
        Route::get('/hero', [WebsiteController::class, 'hero'])->name('hero');
        Route::post('/hero', [WebsiteController::class, 'updateHero'])->name('hero.update');
        
        Route::get('/features', [WebsiteController::class, 'features'])->name('features');
        Route::post('/features', [WebsiteController::class, 'storeFeature'])->name('features.store');
        Route::put('/features/{feature}', [WebsiteController::class, 'updateFeature'])->name('features.update');
        Route::delete('/features/{feature}', [WebsiteController::class, 'deleteFeature'])->name('features.delete');
        
        Route::get('/about', [WebsiteController::class, 'about'])->name('about');
        Route::post('/about', [WebsiteController::class, 'updateAbout'])->name('about.update');
        
        Route::get('/general', [WebsiteController::class, 'general'])->name('general');
        Route::post('/general', [WebsiteController::class, 'updateGeneral'])->name('general.update');
    });

    // Custom Page Management (Placeholder for future development)
    Route::get('/content/custom-page-management', function () {
        return view('content.admin.custom_page_management.index');
    })->name('content-custom-page-management');

    // Menu Management
    Route::prefix('content/menu_management')->name('content-menu_management')->group(function () {
        // View Methods (3 versions)
        Route::get('/', [AdminMenuManagementController::class, 'menuManagementV2'])->name('');
        Route::get('/legacy', [AdminMenuManagementController::class, 'menuManagement'])->name('-legacy');
        Route::get('/improved', [AdminMenuManagementController::class, 'menuManagementImproved'])->name('-improved');
        Route::get('/v2', [AdminMenuManagementController::class, 'menuManagementV2'])->name('-v2');
        
        // CRUD Methods
        Route::post('/store', [AdminMenuManagementController::class, 'store'])->name('-store');
        Route::post('/quick-store', [AdminMenuManagementController::class, 'quickStore'])->name('-quick-store');
        Route::post('/edit', [AdminMenuManagementController::class, 'edit'])->name('-edit');
        Route::post('/update', [AdminMenuManagementController::class, 'update'])->name('-update');
        Route::post('/quick-update', [AdminMenuManagementController::class, 'quickUpdate'])->name('-quick-update');
        Route::delete('/delete', [AdminMenuManagementController::class, 'delete'])->name('-delete');
        Route::put('/status', [AdminMenuManagementController::class, 'updateStatus'])->name('-status');
        
        // Submenu Methods
        Route::post('/quick-add-submenu', [AdminMenuManagementController::class, 'quickAddSubmenu'])->name('-quick-add-submenu');
        Route::post('/update-submenu', [AdminMenuManagementController::class, 'updateSubmenu'])->name('-update-submenu');
        Route::post('/delete-submenu', [AdminMenuManagementController::class, 'deleteSubmenu'])->name('-delete-submenu');
        
        // Advanced Methods
        Route::post('/reorder-menus', [AdminMenuManagementController::class, 'reorderMenus'])->name('-reorder-menus');
        Route::post('/reorder-submenus', [AdminMenuManagementController::class, 'reorderSubmenus'])->name('-reorder-submenus');
        Route::post('/move-menu-item', [AdminMenuManagementController::class, 'moveMenuItem'])->name('-move-menu-item');
        Route::get('/search', [AdminMenuManagementController::class, 'search'])->name('-search');
        Route::get('/get/{id}', [AdminMenuManagementController::class, 'getMenu'])->name('-get');
        Route::post('/check-order-number', [AdminMenuManagementController::class, 'checkOrderNumber'])->name('-check-order-number');
    });
});
