<?php $__env->startSection('title', 'Dashboard - Admin'); ?>

<?php $__env->startSection('vendor-style'); ?>
<?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/apex-charts/apex-charts.scss']); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('vendor-script'); ?>
<?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/apex-charts/apexcharts.js']); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
<?php echo app('Illuminate\Foundation\Vite')(['resources/assets/js/admin-dashboard.js']); ?>
<script>
(function() {
  var refreshUrl = <?php echo json_encode(route('admin.dashboard.stats'), 15, 512) ?>;
  var btn = document.getElementById('dashboardRefresh');
  if (!btn) return;
  function formatNum(v) {
    return Number(v).toLocaleString('en-IN', { maximumFractionDigits: 2, minimumFractionDigits: 0 });
  }
  btn.addEventListener('click', function() {
    var self = this;
    self.disabled = true;
    var icon = self.querySelector('i');
    if (icon) icon.classList.add('fa-spin');
    fetch(refreshUrl, { headers: { 'X-Requested-With': 'XMLHttpRequest', 'Accept': 'application/json' } })
      .then(function(r) { return r.json(); })
      .then(function(data) {
        document.querySelectorAll('[data-stat-value]').forEach(function(el) {
          var key = el.getAttribute('data-stat-value');
          if (key.indexOf('fin_') === 0) {
            var parts = key.split('_');
            var col = parts[1];
            var row = parseInt(parts[2], 10);
            if (data.collection_details && data.collection_details[row]) {
              el.textContent = '₹' + formatNum(data.collection_details[row][col]);
            }
          } else if (key === 'collection_mtd') {
            el.textContent = '₹ ' + formatNum(data[key]);
          } else if (key === 'today_expense' || key === 'total_expense_all') {
            el.textContent = formatNum(data[key]);
          } else if (data[key] !== undefined) {
            el.textContent = data[key];
          }
        });
      })
      .finally(function() {
        self.disabled = false;
        if (icon) icon.classList.remove('fa-spin');
      });
  });

  // Dashboard Add Enquiry: submit via AJAX and stay on dashboard
  var enquiryForm = document.getElementById('dashboardEnquiryForm');
  if (enquiryForm) {
    enquiryForm.addEventListener('submit', function(ev) {
      ev.preventDefault();
      var submitBtn = document.getElementById('dashboardEnquirySubmit');
      if (submitBtn) submitBtn.disabled = true;
      var formData = new FormData(enquiryForm);
      var action = enquiryForm.getAttribute('action');
      fetch(action, {
        method: 'POST',
        body: formData,
        headers: { 'X-Requested-With': 'XMLHttpRequest', 'Accept': 'application/json' }
      }).then(function(r) { return r.json(); }).then(function(data) {
        var modal = document.getElementById('dashboardEnquiryModal');
        if (modal && window.bootstrap) {
          var m = bootstrap.Modal.getInstance(modal);
          if (m) m.hide();
        }
        enquiryForm.reset();
        if (data.message) {
          var alert = document.createElement('div');
          alert.className = 'alert alert-success alert-dismissible';
          alert.innerHTML = data.message + ' <button type="button" class="btn-close" data-bs-dismiss="alert"></button>';
          var container = enquiryForm.closest('.container-xxl');
        var firstRow = container && container.querySelector('.row.g-4');
        if (container && firstRow) container.insertBefore(alert, firstRow);
          setTimeout(function() { alert.remove(); }, 4000);
        }
      }).catch(function() {
        window.location.href = action + '?ajax=0';
      }).finally(function() {
        if (submitBtn) submitBtn.disabled = false;
      });
    });
  }
})();
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y admin-dashboard">
  
  <div class="dashboard-header rounded-3 mb-4">
    <div class="row align-items-center g-3">
      <div class="col-12 col-md-8">
        <h4 class="mb-1 fw-bold text-white">Welcome back, Admin</h4>
        <p class="mb-0 text-white text-opacity-90 small">Today, <?php echo e($today); ?></p>
      </div>
      <div class="col-12 col-md-4 text-md-end">
        <div class="d-flex flex-wrap gap-2 justify-content-md-end">
          <button type="button" class="btn btn-light btn-sm" id="dashboardRefresh" title="Refresh dashboard data"><i class="fas fa-sync-alt me-1"></i>Refresh</button>
          <a href="<?php echo e(route('admin.students.index')); ?>" class="btn btn-light btn-sm">Students</a>
          <a href="<?php echo e(route('admin.reports.index')); ?>" class="btn btn-outline-light btn-sm">Reports</a>
        </div>
      </div>
    </div>
  </div>

  
  <div class="row g-4 mb-4">
    <div class="col-sm-6 col-xl-3">
      <div class="card card-kpi border-0 shadow-sm h-100 overflow-hidden">
        <div class="card-body d-flex align-items-center">
          <div class="kpi-icon rounded-3 bg-primary bg-opacity-10 text-primary me-3">
            <i class="fas fa-user-plus fa-lg"></i>
          </div>
          <div class="flex-grow-1 min-w-0">
            <p class="text-muted small text-uppercase mb-1 fw-medium">Today &amp; All Registration</p>
            <h4 class="mb-0 fw-bold"><span data-stat-value="registered_today"><?php echo e($registeredToday); ?></span> <span class="text-muted fs-6 fw-normal">/ <span data-stat-value="all_students_count"><?php echo e($allStudentsCount); ?></span></span></h4>
          </div>
          <a href="<?php echo e(route('admin.students.index')); ?>" class="btn btn-icon btn-sm btn-outline-primary rounded-pill ms-2"><i class="fas fa-arrow-right"></i></a>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-3">
      <div class="card card-kpi border-0 shadow-sm h-100 overflow-hidden">
        <div class="card-body d-flex align-items-center">
          <div class="kpi-icon rounded-3 bg-info bg-opacity-10 text-info me-3">
            <i class="fas fa-users fa-lg"></i>
          </div>
          <div class="flex-grow-1 min-w-0">
            <p class="text-muted small text-uppercase mb-1 fw-medium">Active / Total Students</p>
            <h4 class="mb-0 fw-bold"><span data-stat-value="active_students"><?php echo e($activeStudents); ?></span> <span class="text-muted fs-6 fw-normal">/ <span data-stat-value="total_students"><?php echo e($totalStudents); ?></span></span></h4>
            <small class="text-success"><span data-stat-value="occupancy_rate"><?php echo e($occupancyRate); ?></span>% rooms occupied</small>
          </div>
          <a href="<?php echo e(route('admin.students.index')); ?>" class="btn btn-icon btn-sm btn-outline-info rounded-pill ms-2"><i class="fas fa-arrow-right"></i></a>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-3">
      <div class="card card-kpi border-0 shadow-sm h-100 overflow-hidden">
        <div class="card-body d-flex align-items-center">
          <div class="kpi-icon rounded-3 bg-danger bg-opacity-10 text-danger me-3">
            <i class="fas fa-rupee-sign fa-lg"></i>
          </div>
          <div class="flex-grow-1 min-w-0">
            <p class="text-muted small text-uppercase mb-1 fw-medium">Today's &amp; Total Expense</p>
            <h4 class="mb-0 fw-bold">₹<span data-stat-value="today_expense"><?php echo e(number_format($todayExpense, 0)); ?></span> <span class="text-muted fs-6 fw-normal">/ ₹<span data-stat-value="total_expense_all"><?php echo e(number_format($totalExpenseAll, 0)); ?></span></span></h4>
          </div>
          <a href="<?php echo e(route('admin.expenses.index')); ?>" class="btn btn-icon btn-sm btn-outline-danger rounded-pill ms-2"><i class="fas fa-arrow-right"></i></a>
        </div>
      </div>
    </div>
    <div class="col-sm-6 col-xl-3">
      <div class="card card-kpi border-0 shadow-sm h-100 overflow-hidden">
        <div class="card-body d-flex align-items-center">
          <div class="kpi-icon rounded-3 bg-success bg-opacity-10 text-success me-3">
            <i class="fas fa-bed fa-lg"></i>
          </div>
          <div class="flex-grow-1 min-w-0">
            <p class="text-muted small text-uppercase mb-1 fw-medium">Vacant Beds</p>
            <h4 class="mb-0 fw-bold"><span data-stat-value="available_beds"><?php echo e($availableBeds); ?></span> <span class="text-muted fs-6 fw-normal">/ <span data-stat-value="total_beds"><?php echo e($totalBeds); ?></span></span></h4>
            <small class="text-muted"><span data-stat-value="occupancy_percent"><?php echo e($occupancyPercent); ?></span>% occupancy</small>
          </div>
          <a href="<?php echo e(route('admin.beds.index')); ?>" class="btn btn-icon btn-sm btn-outline-success rounded-pill ms-2"><i class="fas fa-arrow-right"></i></a>
        </div>
      </div>
    </div>
  </div>

  
  <div class="row g-2 mb-4 align-items-center">
    <div class="col-12 col-lg-8">
      <div class="d-flex flex-wrap gap-2 align-items-center">
        <span class="text-muted small fw-medium me-1">Quick actions:</span>
        <a href="<?php echo e(route('admin.students.registration.create')); ?>" class="btn btn-sm btn-outline-primary rounded-pill"><i class="fas fa-user-plus me-1"></i> Add Student</a>
        <a href="<?php echo e(route('admin.deposits.create')); ?>" class="btn btn-sm btn-outline-primary rounded-pill"><i class="fas fa-credit-card me-1"></i> Add Deposit</a>
        <a href="<?php echo e(route('admin.rents.create')); ?>" class="btn btn-sm btn-outline-primary rounded-pill"><i class="fas fa-rupee-sign me-1"></i> Add Rent</a>
        <a href="<?php echo e(route('admin.floors.create')); ?>" class="btn btn-sm btn-outline-secondary rounded-pill"><i class="fas fa-building me-1"></i> Add Floor</a>
        <a href="<?php echo e(route('admin.rooms.create')); ?>" class="btn btn-sm btn-outline-secondary rounded-pill"><i class="fas fa-square me-1"></i> Add Room</a>
        <button type="button" class="btn btn-sm btn-outline-info rounded-pill" data-bs-toggle="modal" data-bs-target="#dashboardEnquiryModal"><i class="fas fa-question me-1"></i> Add Enquiry</button>
      </div>
    </div>
    <div class="col-12 col-lg-4 text-lg-end">
      <div class="d-inline-block rounded-3 border bg-light px-3 py-2">
        <span class="text-muted small fw-medium">Collection MTD</span>
        <span class="fw-bold ms-2" data-stat-value="collection_mtd">₹ <?php echo e(number_format($collectionMtd ?? 0, 2)); ?></span>
      </div>
    </div>
  </div>

  
  <div class="row g-4 mb-4">
    <div class="col-lg-5">
      <div class="card border-0 shadow-sm h-100">
        <div class="card-header bg-transparent border-0 pb-0 d-flex align-items-center justify-content-between">
          <h5 class="card-title mb-0">Occupancy Overview</h5>
          <span class="badge bg-label-primary"><?php echo e($occupancyPercent); ?>%</span>
        </div>
        <div class="card-body pt-2">
          <div id="occupancyDonutChart" data-occupied="<?php echo e($occupiedBeds); ?>" data-available="<?php echo e($availableBeds); ?>"></div>
        </div>
      </div>
    </div>
    <div class="col-lg-7">
      <div class="card border-0 shadow-sm h-100">
        <div class="card-header bg-transparent border-0 pb-0">
          <h5 class="card-title mb-0">Collection vs Expense (Last 6 Months)</h5>
          <p class="text-muted small mb-0">Values in ₹ thousands</p>
        </div>
        <div class="card-body pt-2">
          <div id="collectionTrendChart"
               data-labels="<?php echo e(json_encode($monthlyCollectionLabels)); ?>"
               data-collection="<?php echo e(json_encode($monthlyCollectionData)); ?>"
               data-expense="<?php echo e(json_encode($monthlyExpenseData)); ?>"></div>
        </div>
      </div>
    </div>
  </div>

  
  <div class="row g-4 mb-4">
    <div class="col-xl-6">
      <div class="card border-0 shadow-sm">
        <div class="card-header bg-transparent border-0 d-flex flex-wrap align-items-center justify-content-between gap-2">
          <h5 class="card-title mb-0">Advanced Financial Matrix</h5>
          <div class="d-flex align-items-center gap-2">
            <input type="text" class="form-control form-control-sm" value="<?php echo e($dateFrom); ?>" style="max-width: 105px;" readonly>
            <span class="text-muted">to</span>
            <input type="text" class="form-control form-control-sm" value="<?php echo e($dateTo); ?>" style="max-width: 105px;" readonly>
          </div>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-hover align-middle mb-0" id="dashboardFinancialTable">
              <thead class="table-light">
                <tr>
                  <th class="border-0 ps-4">#</th>
                  <th class="border-0 text-end">Total</th>
                  <th class="border-0 text-end">Cash</th>
                  <th class="border-0 text-end pe-4">Bank</th>
                </tr>
              </thead>
              <tbody>
                <?php $__currentLoopData = $collectionDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr data-row-index="<?php echo e($i); ?>">
                    <td class="ps-4 fw-medium"><?php echo e($row['label']); ?></td>
                    <td class="text-end" data-stat-value="fin_total_<?php echo e($i); ?>">₹<?php echo e(number_format($row['total'], 2)); ?></td>
                    <td class="text-end" data-stat-value="fin_cash_<?php echo e($i); ?>">₹<?php echo e(number_format($row['cash'], 2)); ?></td>
                    <td class="text-end pe-4" data-stat-value="fin_bank_<?php echo e($i); ?>">₹<?php echo e(number_format($row['bank'], 2)); ?></td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <div class="col-xl-6">
      <div class="card border-0 shadow-sm h-100">
        <div class="card-header bg-transparent border-0 d-flex align-items-center justify-content-between">
          <div>
            <h5 class="card-title mb-0">Room Overview</h5>
            <p class="text-muted small mb-0">Availability & vacant beds</p>
          </div>
          <div class="form-check form-switch mb-0">
            <input class="form-check-input" type="checkbox" id="allFloor" checked>
            <label class="form-check-label small" for="allFloor">All floors</label>
          </div>
        </div>
        <div class="card-body">
          <?php $__currentLoopData = $floors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $floor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="floor-section mb-4">
              <h6 class="text-muted small text-uppercase fw-semibold mb-2"><?php echo e($floor['name']); ?></h6>
              <div class="row g-2">
                <?php $__currentLoopData = $floor['rooms']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $room): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php
                    $beds = $room['beds'];
                    $total = count($beds);
                    $occupied = count(array_filter($beds, fn($b) => !$b));
                    $pct = $total ? round(($occupied / $total) * 100) : 0;
                  ?>
                  <div class="col-6 col-md-4">
                    <div class="room-card rounded-3 p-3 border">
                      <div class="d-flex justify-content-between align-items-center mb-2">
                        <a href="<?php echo e(route('admin.rooms.show', $room['id'])); ?>" class="fw-semibold text-body">Room <?php echo e($room['number']); ?></a>
                        <span class="badge bg-label-<?php echo e($pct >= 75 ? 'success' : ($pct >= 50 ? 'warning' : 'secondary')); ?>"><?php echo e($occupied); ?>/<?php echo e($total); ?></span>
                      </div>
                      <div class="progress rounded-pill" style="height: 8px;">
                        <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo e(100 - $pct); ?>%"></div>
                        <div class="progress-bar bg-danger" role="progressbar" style="width: <?php echo e($pct); ?>%"></div>
                      </div>
                      <div class="d-flex gap-1 mt-2 flex-wrap">
                        <?php $__currentLoopData = $beds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $available): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <span class="bed-dot rounded-circle <?php echo e($available ? 'bg-success' : 'bg-danger'); ?>" title="<?php echo e($available ? 'Available' : 'Occupied'); ?>"></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </div>
                    </div>
                  </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>
    </div>
  </div>

  
  <div class="modal fade" id="dashboardEnquiryModal" tabindex="-1" aria-labelledby="dashboardEnquiryModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <form id="dashboardEnquiryForm" action="<?php echo e(route('admin.enquiries.store')); ?>" method="POST">
          <?php echo csrf_field(); ?>
          <div class="modal-header">
            <h5 class="modal-title" id="dashboardEnquiryModalLabel">Add New Enquiry</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>
          <div class="modal-body">
            <div class="mb-3">
              <label class="form-label">Name <span class="text-danger">*</span></label>
              <input type="text" class="form-control" name="name" required>
            </div>
            <div class="mb-3">
              <label class="form-label">Mobile <span class="text-danger">*</span></label>
              <input type="text" class="form-control" name="mobile" required>
            </div>
            <div class="mb-3">
              <label class="form-label">College / Class</label>
              <input type="text" class="form-control" name="class" placeholder="e.g. FY B.Com">
            </div>
            <div class="mb-3">
              <label class="form-label">Address</label>
              <input type="text" class="form-control" name="address" placeholder="Locality, city">
            </div>
            <div class="mb-0">
              <label class="form-label">Message</label>
              <textarea class="form-control" name="message" rows="3" placeholder="Requirements or questions"></textarea>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="dashboardEnquirySubmit">Save Enquiry</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  
  <div class="text-center text-muted small py-3">
    © <?php echo e(date('Y')); ?> Shri Gurudev Hostel. All rights reserved.
  </div>
</div>

<style>
.admin-dashboard .dashboard-header {
  background: linear-gradient(135deg, #696cff 0%, #5f61e6 50%, #5658d3 100%);
  padding: 1.25rem 1.5rem;
}
.admin-dashboard .card-kpi {
  transition: transform 0.2s ease, box-shadow 0.2s ease;
}
.admin-dashboard .card-kpi:hover {
  transform: translateY(-2px);
  box-shadow: 0 0.5rem 1rem rgba(0,0,0,0.08) !important;
}
.admin-dashboard .kpi-icon {
  width: 48px;
  height: 48px;
  display: flex;
  align-items: center;
  justify-content: center;
}
.admin-dashboard .bed-dot {
  width: 10px;
  height: 10px;
  display: inline-block;
}
.admin-dashboard .room-card {
  background: var(--bs-body-bg, #fff);
}
.admin-dashboard .table-hover tbody tr:hover {
  background-color: rgba(105, 108, 255, 0.04);
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentNavbarLayout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/GurudevHostel/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>