<?php $__env->startSection('title', 'Student Details - ' . $student->full_name); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Student Details</h4>
        <div class="d-flex gap-2">
            <a href="<?php echo e(route('admin.students.edit', $student)); ?>" class="btn btn-outline-primary"><i class="ri-edit-line me-1"></i>Edit</a>
            <a href="<?php echo e(route('admin.students.index')); ?>" class="btn btn-outline-secondary"><i class="ri-arrow-left-line me-1"></i>Back to List</a>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="row">
        
        <div class="col-md-4 mb-4">
            <div class="card h-100">
                <div class="card-body text-center">
                    <?php $profileDoc = $student->documents->where('document_type', 'profile_photo')->first(); ?>
                    <?php if($profileDoc): ?>
                        <img src="<?php echo e(asset('storage/' . $profileDoc->file_path)); ?>" alt="Profile" class="rounded-circle mb-2" style="width:100px;height:100px;object-fit:cover;">
                    <?php else: ?>
                        <span class="avatar avatar-lg rounded-circle bg-label-secondary d-inline-flex align-items-center justify-content-center" style="width:100px;height:100px;font-size:2rem;"><?php echo e(strtoupper(mb_substr($student->first_name ?? '', 0, 1))); ?></span>
                    <?php endif; ?>
                    <h5 class="mb-1"><?php echo e($student->full_name); ?></h5>
                    <p class="text-muted small mb-0">
                        <?php echo e(config('student_registration.status.' . $student->status, $student->status)); ?> · <?php echo e(config('student_registration.form_status.' . $student->form_status, $student->form_status)); ?>

                    </p>
                    <?php if($student->room_bed_identifier): ?>
                        <p class="small mb-0 mt-1"><strong>Room / Bed:</strong> <?php echo e($student->room_bed_identifier); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        
        <div class="col-md-8 mb-4">
            <div class="card">
                <div class="card-body">
                    <h6 class="card-title mb-3">Personal</h6>
                    <div class="row g-2 small">
                        <div class="col-4 text-muted">Email</div><div class="col-8"><?php echo e($student->email ?? '—'); ?></div>
                        <div class="col-4 text-muted">Mobile</div><div class="col-8"><?php echo e($student->student_mobile ?? '—'); ?></div>
                        <div class="col-4 text-muted">Parent Mobile</div><div class="col-8"><?php echo e($student->parent_mobile ?? '—'); ?></div>
                        <div class="col-4 text-muted">DOB</div><div class="col-8"><?php echo e($student->date_of_birth?->format('d/m/Y') ?? '—'); ?></div>
                        <div class="col-4 text-muted">Aadhar</div><div class="col-8"><?php echo e($student->aadhar_number ?? '—'); ?></div>
                        <div class="col-4 text-muted">Address</div><div class="col-8"><?php echo e(trim(implode(', ', array_filter([$student->permanent_locality, $student->permanent_taluka, $student->permanent_district, $student->permanent_state]))) ?: '—'); ?></div>
                    </div>
                    <hr>
                    <h6 class="card-title mb-3">Hostel & College</h6>
                    <div class="row g-2 small">
                        <div class="col-4 text-muted">Room / Bed</div><div class="col-8"><?php echo e($student->room_bed_identifier ?? '—'); ?></div>
                        <div class="col-4 text-muted">College</div><div class="col-8"><?php echo e($student->college_name ?? '—'); ?></div>
                        <div class="col-4 text-muted">Stream</div><div class="col-8"><?php echo e($student->stream ? config('student_registration.streams.' . $student->stream, $student->stream) : '—'); ?></div>
                        <div class="col-4 text-muted">Standard / Year</div><div class="col-8"><?php echo e($student->standard_year ?? '—'); ?></div>
                        <div class="col-4 text-muted">Reference</div><div class="col-8"><?php echo e($student->reference_name ? $student->reference_name . ($student->reference_contact ? ' (' . $student->reference_contact . ')' : '') : '—'); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="card mb-4" id="documents">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Student Documents</h5>
            <a href="<?php echo e(route('admin.students.registration.step2', $student)); ?>" class="btn btn-sm btn-outline-primary">Upload / Edit</a>
        </div>
        <div class="card-body">
            <?php $documentTypes = config('student_registration.document_types', []); ?>
            <?php if($student->documents->isEmpty()): ?>
                <p class="text-muted mb-0">No documents uploaded.</p>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead><tr><th>Type</th><th>File</th><th>Size</th></tr></thead>
                        <tbody>
                            <?php $__currentLoopData = $student->documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($documentTypes[$doc->document_type] ?? $doc->document_type); ?></td>
                                    <td>
                                        <a href="<?php echo e(asset('storage/' . $doc->file_path)); ?>" target="_blank" rel="noopener"><?php echo e($doc->original_name ?? basename($doc->file_path)); ?></a>
                                    </td>
                                    <td><?php echo e($doc->file_size ? number_format($doc->file_size / 1024, 1) . ' KB' : '—'); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>

    
    <div class="card mb-4" id="agreement-history">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Agreement History</h5>
            <a href="<?php echo e(route('admin.agreements.index')); ?>?student_id=<?php echo e($student->id); ?>" class="btn btn-sm btn-outline-primary">View / Add</a>
        </div>
        <div class="card-body">
            <?php if($student->agreementHistories->isEmpty()): ?>
                <p class="text-muted mb-0">No agreement records.</p>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead><tr><th>From</th><th>To</th></tr></thead>
                        <tbody>
                            <?php $__currentLoopData = $student->agreementHistories->sortBy('from_date'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($ag->from_date?->format('d/m/Y') ?? '—'); ?></td>
                                    <td><?php echo e($ag->to_date?->format('d/m/Y') ?? '—'); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>

    
    <?php if($student->deposits->isNotEmpty()): ?>
    <div class="card mb-4">
        <div class="card-header"><h5 class="mb-0">Deposits</h5></div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-sm">
                    <thead><tr><th>From</th><th>To</th><th>Amount</th><th>Payment</th><th>Date</th></tr></thead>
                    <tbody>
                        <?php $__currentLoopData = $student->deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($d->from_date?->format('d/m/Y') ?? '—'); ?></td>
                                <td><?php echo e($d->to_date?->format('d/m/Y') ?? '—'); ?></td>
                                <td><?php echo e($d->amount ? '₹' . number_format($d->amount, 2) : '—'); ?></td>
                                <td><?php echo e($d->payment_mode ? config('student_registration.payment_modes.' . $d->payment_mode, $d->payment_mode) : '—'); ?></td>
                                <td><?php echo e($d->actual_deposit_date?->format('d/m/Y') ?? '—'); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php endif; ?>

    
    <div class="card mb-4" id="payment-history">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Payment History (Rent)</h5>
            <a href="<?php echo e(route('admin.rents.create')); ?>?student_id=<?php echo e($student->id); ?>" class="btn btn-sm btn-outline-primary">Add Rent</a>
        </div>
        <div class="card-body">
            <?php if($student->rents->isEmpty()): ?>
                <p class="text-muted mb-0">No rent payments recorded.</p>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead><tr><th>Period From</th><th>Period To</th><th>Amount</th><th>Mode</th><th>Paid On</th></tr></thead>
                        <tbody>
                            <?php $__currentLoopData = $student->rents->sortByDesc('paid_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($r->period_from?->format('d/m/Y') ?? '—'); ?></td>
                                    <td><?php echo e($r->period_to?->format('d/m/Y') ?? '—'); ?></td>
                                    <td><?php echo e($r->amount ? '₹' . number_format($r->amount, 2) : '—'); ?></td>
                                    <td><?php echo e($r->payment_mode ? config('student_registration.payment_modes.' . $r->payment_mode, $r->payment_mode) : '—'); ?></td>
                                    <td><?php echo e($r->paid_at?->format('d/m/Y H:i') ?? '—'); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>

    
    <div class="card mb-4" id="room-history">
        <div class="card-header"><h5 class="mb-0">Room History</h5></div>
        <div class="card-body">
            <?php if($student->bedHistory->isEmpty()): ?>
                <p class="text-muted mb-0">No room transfer history. Current: <?php echo e($student->room_bed_identifier ?? '—'); ?></p>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead><tr><th>Floor</th><th>Room</th><th>Bed</th><th>Allotted At</th><th>Left At</th></tr></thead>
                        <tbody>
                            <?php $__currentLoopData = $student->bedHistory->sortByDesc('allotted_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $h): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($h->floor->name ?? '—'); ?></td>
                                    <td><?php echo e($h->room->name ?? '—'); ?></td>
                                    <td><?php echo e($h->bed->name ?? '—'); ?></td>
                                    <td><?php echo e($h->allotted_at?->format('d/m/Y H:i') ?? '—'); ?></td>
                                    <td><?php echo e($h->left_at?->format('d/m/Y H:i') ?? '—'); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <p class="small text-muted mb-0 mt-2">Current: <?php echo e($student->room_bed_identifier ?? '—'); ?></p>
            <?php endif; ?>
        </div>
    </div>

    
    <div class="card mb-4" id="remarks">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Remarks</h5>
            <a href="<?php echo e(route('admin.agreements.index')); ?>?student_id=<?php echo e($student->id); ?>" class="btn btn-sm btn-outline-primary">View / Add Remark</a>
        </div>
        <div class="card-body">
            <?php if($student->remarks->isEmpty()): ?>
                <p class="text-muted mb-0">No remarks recorded. Use <a href="<?php echo e(route('admin.agreements.index')); ?>?student_id=<?php echo e($student->id); ?>">View Agreement</a> to add a remark.</p>
            <?php else: ?>
                <ul class="list-unstyled mb-0">
                    <?php $__currentLoopData = $student->remarks->sortByDesc('remarked_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="mb-2">
                            <span class="text-muted small"><?php echo e($rm->remarked_at->format('d/m/Y')); ?></span> — <?php echo e($rm->remark); ?>

                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentNavbarLayout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/GurudevHostel/resources/views/admin/students/show.blade.php ENDPATH**/ ?>