<?php $__env->startSection('title', 'Student Details'); ?>

<?php $__env->startSection('vendor-style'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" />
<style>
#studentsTable thead th { font-weight: 600; text-transform: uppercase; font-size: 0.75rem; }
#studentsTable_wrapper .row:first-child { margin-bottom: 1rem; }
#studentsTable_wrapper .row:last-child { margin-top: 1rem; }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Student Details</h4>
        <a href="<?php echo e(route('admin.students.registration.create')); ?>" class="btn btn-primary">+ Add Student</a>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    
    <div class="row g-4 mb-4">
        <div class="col-xl-3 col-sm-6">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div class="card-info">
                            <p class="card-text mb-1">Total Students</p>
                            <h4 class="card-title mb-0"><?php echo e(number_format($totalStudents ?? 0)); ?></h4>
                        </div>
                        <div class="card-icon">
                            <span class="badge bg-label-primary rounded p-2"><i class="ri-user-line ri-lg"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-sm-6">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div class="card-info">
                            <p class="card-text mb-1">Active</p>
                            <h4 class="card-title mb-0"><?php echo e(number_format($counts['active'] ?? 0)); ?></h4>
                        </div>
                        <div class="card-icon">
                            <span class="badge bg-label-success rounded p-2"><i class="ri-user-follow-line ri-lg"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-sm-6">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div class="card-info">
                            <p class="card-text mb-1">Information Pending</p>
                            <h4 class="card-title mb-0"><?php echo e(number_format($counts['information_pending'] ?? 0)); ?></h4>
                        </div>
                        <div class="card-icon">
                            <span class="badge bg-label-warning rounded p-2"><i class="ri-time-line ri-lg"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-sm-6">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div class="card-info">
                            <p class="card-text mb-1">Alumna</p>
                            <h4 class="card-title mb-0"><?php echo e(number_format($counts['alumna'] ?? 0)); ?></h4>
                        </div>
                        <div class="card-icon">
                            <span class="badge bg-label-info rounded p-2"><i class="ri-user-unfollow-line ri-lg"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <ul class="nav nav-tabs mb-3" role="tablist">
        <?php $__currentLoopData = $filters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li class="nav-item">
                <a href="<?php echo e(route('admin.students.index', ['filter' => $key])); ?>"
                   class="nav-link <?php echo e($activeFilter === $key ? 'active' : ''); ?>">
                    <?php echo e($label); ?>

                    <span class="badge bg-<?php echo e($activeFilter === $key ? 'primary' : 'secondary'); ?> rounded-pill ms-1"><?php echo e($counts[$key] ?? 0); ?></span>
                </a>
            </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>

    
    <div class="card">
        <div class="card-body">
            
            <div class="d-flex justify-content-end gap-2 mb-3">
                <a href="<?php echo e(route('admin.students.export', ['format' => 'excel', 'filter' => $activeFilter])); ?>" class="btn btn-success"><i class="ri-file-excel-2-line me-1"></i>Excel</a>
                <button type="button" class="btn btn-danger" id="exportPdf"><i class="ri-file-pdf-line me-1"></i>PDF</button>
                <button type="button" class="btn btn-info" id="exportPrint"><i class="ri-printer-line me-1"></i>Print</button>
            </div>
            <div class="table-responsive">
                <table class="table table-hover" id="studentsTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>SR NO.</th>
                            <th>PROFILE</th>
                            <th>NAME</th>
                            <th>MOBILE</th>
                            <th>ROOM / BED</th>
                            <th>ADMISSION DATE</th>
                            <th>LEAVING DATE</th>
                            <th>RENT</th>
                            <th>REMARK</th>
                            <th>ACTION</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
<script src="https://code.jquery.com/jquery-3.7.1.min.js" crossorigin="anonymous"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script>
(function() {
    var dataUrl = <?php echo json_encode(route('admin.students.data'), 15, 512) ?>;
    var activeFilter = <?php echo json_encode($activeFilter, 15, 512) ?>;

    var table = jQuery('#studentsTable').DataTable({
        serverSide: true,
        ajax: {
            url: dataUrl,
            data: function(d) {
                d.filter = activeFilter;
            }
        },
        columns: [
            { data: 'sr_no', name: 'sr_no', width: '60px', orderable: false },
            { data: 'profile', name: 'profile', width: '50px', orderable: false, searchable: false, render: function(d) { return d || ''; } },
            { data: 'full_name', name: 'full_name' },
            { data: 'contact', name: 'contact' },
            { data: 'room_bed_identifier', name: 'room_bed_identifier' },
            { data: 'admission_date', name: 'admission_date', width: '100px' },
            { data: 'leaving_date', name: 'leaving_date', width: '100px' },
            { data: 'rent', name: 'rent', width: '80px' },
            { data: 'remark', name: 'remark', width: '80px', orderable: false },
            { data: 'actions', name: 'actions', orderable: false, searchable: false, width: '100px', render: function(d) { return d || ''; } }
        ],
        order: [[2, 'asc']],
        pageLength: 10,
        lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
        language: {
            lengthMenu: 'Show _MENU_ entries',
            search: 'Search:',
            searchPlaceholder: '',
            info: 'Showing _START_ to _END_ of _TOTAL_ entries',
            infoEmpty: 'Showing 0 to 0 of 0 entries',
            infoFiltered: '(filtered from _MAX_ total entries)',
            zeroRecords: 'No matching records found',
            paginate: { first: 'First', last: 'Last', next: 'Next', previous: 'Previous' },
            processing: 'Processing...'
        },
        columnDefs: [
            { orderable: false, targets: [0, 1, 8, 9] }
        ],
        processing: true,
        stateSave: false,
        dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>rtip'
    });

    jQuery('#exportPrint, #exportPdf').on('click', function(e) {
        e.preventDefault();
        window.print();
    });
})();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentNavbarLayout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/GurudevHostel/resources/views/admin/students/registration/index.blade.php ENDPATH**/ ?>