<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($hostelSettings->name ?? 'Gurudev Hostel'); ?> - Home</title>
    <meta name="description" content="<?php echo e($websiteSettings->meta_description ?? $hostelSettings->description ?? 'Welcome to our hostel'); ?>">
    <?php if($websiteSettings->meta_keywords): ?>
    <meta name="keywords" content="<?php echo e($websiteSettings->meta_keywords); ?>">
    <?php endif; ?>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('assets/img/favicon/favicon.ico')); ?>">
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Remix Icons -->
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/node-waves/node-waves.scss']); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/scss/core.scss', 'resources/assets/css/demo.css']); ?>
    
    <style>
        :root {
            --primary-color: <?php echo e($websiteSettings->primary_color ?? '#696cff'); ?>;
            --primary-dark: #5f61e6;
            --secondary-color: <?php echo e($websiteSettings->secondary_color ?? '#8592a3'); ?>;
            --light-bg: #f8f9fa;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            overflow-x: hidden;
        }
        
        /* Hero Section */
        .hero-section {
            min-height: 100vh;
            <?php if($websiteSettings->hero_background_image): ?>
            background: linear-gradient(135deg, rgba(102, 126, 234, 0.8) 0%, rgba(118, 75, 162, 0.8) 100%), url('<?php echo e(asset("storage/" . $websiteSettings->hero_background_image)); ?>');
            background-size: cover;
            background-position: center;
            <?php else: ?>
            background: linear-gradient(135deg, <?php echo e($websiteSettings->hero_background_color ?? '#667eea'); ?> 0%, #764ba2 100%);
            <?php endif; ?>
            color: white;
            position: relative;
            overflow: hidden;
        }
        
        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E");
        }
        
        .hero-content {
            position: relative;
            z-index: 1;
        }
        
        .hero-title {
            font-size: 3.5rem;
            font-weight: 800;
            margin-bottom: 1.5rem;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
        }
        
        .hero-subtitle {
            font-size: 1.25rem;
            font-weight: 300;
            margin-bottom: 2.5rem;
            opacity: 0.95;
        }
        
        .btn-hero {
            padding: 14px 40px;
            font-size: 1.1rem;
            font-weight: 600;
            border-radius: 50px;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .btn-hero-primary {
            background: white;
            color: var(--primary-color);
            border: 2px solid white;
        }
        
        .btn-hero-primary:hover {
            background: transparent;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.2);
        }
        
        .btn-hero-outline {
            background: transparent;
            color: white;
            border: 2px solid white;
        }
        
        .btn-hero-outline:hover {
            background: white;
            color: var(--primary-color);
            transform: translateY(-2px);
        }
        
        /* Features Section */
        .features-section {
            padding: 100px 0;
            background: white;
        }
        
        .section-title {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 1rem;
            color: #2c3e50;
        }
        
        .section-subtitle {
            font-size: 1.1rem;
            color: var(--secondary-color);
            margin-bottom: 4rem;
        }
        
        .feature-card {
            padding: 2rem;
            border-radius: 16px;
            background: white;
            border: 1px solid #e7e7e7;
            transition: all 0.3s ease;
            height: 100%;
        }
        
        .feature-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            border-color: var(--primary-color);
        }
        
        .feature-icon {
            width: 70px;
            height: 70px;
            border-radius: 16px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            margin-bottom: 1.5rem;
        }
        
        .feature-title {
            font-size: 1.3rem;
            font-weight: 600;
            margin-bottom: 0.75rem;
            color: #2c3e50;
        }
        
        .feature-description {
            color: var(--secondary-color);
            line-height: 1.6;
        }
        
        /* About Section */
        .about-section {
            padding: 100px 0;
            background: var(--light-bg);
        }
        
        .about-image {
            border-radius: 24px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.15);
            width: 100%;
            height: auto;
        }
        
        .about-content {
            padding: 2rem 0;
        }
        
        .stat-box {
            text-align: center;
            padding: 1.5rem;
            background: white;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.08);
        }
        
        .stat-number {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--primary-color);
            display: block;
        }
        
        .stat-label {
            color: var(--secondary-color);
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        /* Contact Section */
        .contact-section {
            padding: 100px 0;
            background: white;
        }
        
        .contact-card {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            border: 1px solid #e7e7e7;
            height: 100%;
            transition: all 0.3s ease;
        }
        
        .contact-card:hover {
            border-color: var(--primary-color);
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        .contact-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            background: rgba(102, 126, 234, 0.1);
            color: var(--primary-color);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            margin-bottom: 1rem;
        }
        
        .contact-title {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
            color: #2c3e50;
        }
        
        .contact-info {
            color: var(--secondary-color);
        }
        
        /* Footer */
        .footer-section {
            background: #2c3e50;
            color: white;
            padding: 60px 0 30px;
        }
        
        .footer-brand {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 1rem;
        }
        
        .footer-description {
            opacity: 0.8;
            margin-bottom: 1.5rem;
        }
        
        .social-links a {
            display: inline-flex;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(255,255,255,0.1);
            align-items: center;
            justify-content: center;
            color: white;
            margin-right: 10px;
            transition: all 0.3s ease;
        }
        
        .social-links a:hover {
            background: var(--primary-color);
            transform: translateY(-3px);
        }
        
        .footer-bottom {
            border-top: 1px solid rgba(255,255,255,0.1);
            padding-top: 30px;
            margin-top: 40px;
            text-align: center;
            opacity: 0.8;
        }
        
        /* Enquiry Form */
        .enquiry-form-card {
            border-radius: 20px;
            overflow: hidden;
        }
        
        .enquiry-form-card .form-control,
        .enquiry-form-card .form-control-lg {
            border-radius: 8px;
            border: 2px solid #e7e7e7;
            padding: 12px 18px;
            transition: all 0.3s ease;
        }
        
        .enquiry-form-card .form-control:focus,
        .enquiry-form-card .form-control-lg:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.15);
        }
        
        .enquiry-form-card .form-label {
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 0.5rem;
        }
        
        /* Navbar */
        .navbar-landing {
            padding: 1.5rem 0;
            transition: all 0.3s ease;
        }
        
        .navbar-landing.scrolled {
            background: white !important;
            box-shadow: 0 2px 20px rgba(0,0,0,0.1);
        }
        
        .navbar-landing.scrolled .nav-link,
        .navbar-landing.scrolled .navbar-brand {
            color: #2c3e50 !important;
        }
        
        @media (max-width: 768px) {
            .hero-title {
                font-size: 2.5rem;
            }
            
            .hero-subtitle {
                font-size: 1rem;
            }
            
            .btn-hero {
                padding: 12px 30px;
                font-size: 1rem;
            }
            
            .section-title {
                font-size: 2rem;
            }
            
            .features-section, .about-section, .contact-section {
                padding: 60px 0;
            }
        }
        
        /* Custom CSS from Admin */
        <?php if($websiteSettings->custom_css): ?>
        <?php echo $websiteSettings->custom_css; ?>

        <?php endif; ?>
    </style>
</head>
<body>

    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-landing position-absolute w-100" style="z-index: 100;">
        <div class="container">
            <a class="navbar-brand text-white fw-bold" href="<?php echo e(route('home')); ?>">
                <?php if($hostelSettings->logo): ?>
                    <img src="<?php echo e(asset('storage/' . $hostelSettings->logo)); ?>" alt="<?php echo e($hostelSettings->name); ?>" style="height: 40px;">
                <?php else: ?>
                    <?php echo e($hostelSettings->name); ?>

                <?php endif; ?>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link text-white" href="#features">Features</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link text-white" href="#about">About</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link text-white" href="#contact">Contact</a>
                    </li>
                    <li class="nav-item ms-3">
                        <a class="btn btn-sm btn-light rounded-pill" href="<?php echo e(route('admin.login')); ?>">
                            <i class="ri-login-box-line me-1"></i> Admin Login
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section d-flex align-items-center">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8 mx-auto text-center hero-content">
                    <h1 class="hero-title animate__animated animate__fadeInUp">
                        <?php echo e($websiteSettings->hero_title ?? $hostelSettings->name ?? 'Gurudev Hostel'); ?>

                    </h1>
                    <p class="hero-subtitle animate__animated animate__fadeInUp animate__delay-1s">
                        <?php echo e($websiteSettings->hero_subtitle ?? $hostelSettings->description ?? 'Your home away from home. Experience comfort, safety, and community living at its finest.'); ?>

                    </p>
                    <div class="animate__animated animate__fadeInUp animate__delay-2s">
                        <a href="<?php echo e($websiteSettings->hero_button_link ?? '#contact'); ?>" class="btn btn-hero btn-hero-primary me-3"><?php echo e($websiteSettings->hero_button_text ?? 'Get In Touch'); ?></a>
                        <a href="#about" class="btn btn-hero btn-hero-outline">Learn More</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="features-section" id="features">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title">Our Facilities</h2>
                <p class="section-subtitle">Everything you need for comfortable living</p>
            </div>
            <div class="row g-4">
                <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6 col-lg-3">
                    <div class="feature-card text-center">
                        <div class="feature-icon mx-auto">
                            <i class="<?php echo e($feature->icon); ?>"></i>
                        </div>
                        <h3 class="feature-title"><?php echo e($feature->title); ?></h3>
                        <p class="feature-description"><?php echo e($feature->description); ?></p>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section class="about-section" id="about">
        <div class="container">
            <div class="row align-items-center g-5">
                <div class="col-lg-6">
                    <img src="<?php echo e(asset('assets/img/illustrations/page-misc-under-maintenance.png')); ?>" alt="About Us" class="about-image">
                </div>
                <div class="col-lg-6 about-content">
                    <h2 class="section-title"><?php echo e($websiteSettings->about_title ?? 'About ' . ($hostelSettings->name ?? 'Our Hostel')); ?></h2>
                    <div class="text-muted mb-5" style="font-size: 1.1rem; line-height: 1.8;">
                        <?php echo nl2br(e($websiteSettings->about_description ?? 'We provide a safe, comfortable, and welcoming environment for students and working professionals. Our hostel combines modern amenities with a homely atmosphere, ensuring that every resident feels at home while pursuing their goals.')); ?>

                    </div>
                    <div class="row g-4">
                        <div class="col-6">
                            <div class="stat-box">
                                <span class="stat-number"><?php echo e($websiteSettings->stat_residents ?? 100); ?>+</span>
                                <span class="stat-label">Happy Residents</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="stat-box">
                                <span class="stat-number"><?php echo e($websiteSettings->stat_experience ?? 5); ?>+</span>
                                <span class="stat-label">Years Experience</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section class="contact-section" id="contact">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title">Get In Touch</h2>
                <p class="section-subtitle">We'd love to hear from you</p>
            </div>
            
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show shadow-sm mb-5" role="alert">
                    <div class="d-flex align-items-center">
                        <i class="ri-checkbox-circle-line me-2 fs-4"></i>
                        <span><?php echo e(session('success')); ?></span>
                    </div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            
            <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show shadow-sm mb-5" role="alert">
                    <div class="d-flex align-items-start">
                        <i class="ri-error-warning-line me-2 fs-4 mt-1"></i>
                        <div>
                            <strong class="d-block mb-2">Please correct the following errors:</strong>
                            <ul class="mb-0 ps-3">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>
            
            <div class="row g-4">
                <?php if($hostelSettings->address): ?>
                <div class="col-md-6 col-lg-3">
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="ri-map-pin-line"></i>
                        </div>
                        <h4 class="contact-title">Address</h4>
                        <p class="contact-info">
                            <?php echo e($hostelSettings->address); ?><br>
                            <?php if($hostelSettings->city): ?><?php echo e($hostelSettings->city); ?><?php endif; ?>
                            <?php if($hostelSettings->state): ?>, <?php echo e($hostelSettings->state); ?><?php endif; ?>
                            <?php if($hostelSettings->pincode): ?> - <?php echo e($hostelSettings->pincode); ?><?php endif; ?>
                        </p>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if($hostelSettings->phone || $hostelSettings->mobile): ?>
                <div class="col-md-6 col-lg-3">
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="ri-phone-line"></i>
                        </div>
                        <h4 class="contact-title">Phone</h4>
                        <p class="contact-info">
                            <?php if($hostelSettings->phone): ?><?php echo e($hostelSettings->phone); ?><br><?php endif; ?>
                            <?php if($hostelSettings->mobile): ?><?php echo e($hostelSettings->mobile); ?><?php endif; ?>
                        </p>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if($hostelSettings->email): ?>
                <div class="col-md-6 col-lg-3">
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="ri-mail-line"></i>
                        </div>
                        <h4 class="contact-title">Email</h4>
                        <p class="contact-info">
                            <a href="mailto:<?php echo e($hostelSettings->email); ?>" class="text-decoration-none" style="color: var(--secondary-color);">
                                <?php echo e($hostelSettings->email); ?>

                            </a>
                        </p>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if($hostelSettings->website): ?>
                <div class="col-md-6 col-lg-3">
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="ri-global-line"></i>
                        </div>
                        <h4 class="contact-title">Website</h4>
                        <p class="contact-info">
                            <a href="<?php echo e($hostelSettings->website); ?>" target="_blank" class="text-decoration-none" style="color: var(--secondary-color);">
                                Visit Website
                            </a>
                        </p>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            
            <!-- Enquiry Form -->
            <div class="row mt-5">
                <div class="col-lg-8 mx-auto">
                    <div class="card border-0 shadow-lg enquiry-form-card">
                        <div class="card-body p-4 p-lg-5">
                            <div class="text-center mb-4">
                                <h3 class="fw-bold mb-2">Send Us An Enquiry</h3>
                                <p class="text-muted">Fill out the form below and we'll get back to you soon</p>
                            </div>
                            <form action="<?php echo e(route('home.enquiry')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label class="form-label">Name <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control form-control-lg <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="name" value="<?php echo e(old('name')); ?>" required placeholder="Your Full Name">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Mobile <span class="text-danger">*</span></label>
                                        <input type="tel" class="form-control form-control-lg <?php $__errorArgs = ['mobile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="mobile" value="<?php echo e(old('mobile')); ?>" required placeholder="10-digit mobile number">
                                        <?php $__errorArgs = ['mobile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Email</label>
                                        <input type="email" class="form-control form-control-lg <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email" value="<?php echo e(old('email')); ?>" placeholder="your@email.com">
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">College/Class</label>
                                        <input type="text" class="form-control form-control-lg <?php $__errorArgs = ['college'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="college" value="<?php echo e(old('college')); ?>" placeholder="Your College/Class">
                                        <?php $__errorArgs = ['college'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label">Address</label>
                                        <textarea class="form-control <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="address" rows="2" placeholder="Your Current Address"><?php echo e(old('address')); ?></textarea>
                                        <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label">Message</label>
                                        <textarea class="form-control <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="message" rows="4" placeholder="Tell us about your enquiry..."><?php echo e(old('message')); ?></textarea>
                                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-12 text-center">
                                        <button type="submit" class="btn btn-lg btn-primary px-5 rounded-pill">
                                            <i class="ri-send-plane-fill me-2"></i>Submit Enquiry
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer-section">
        <div class="container">
            <div class="row g-5">
                <div class="col-lg-4">
                    <div class="footer-brand"><?php echo e($hostelSettings->name ?? 'Gurudev Hostel'); ?></div>
                    <p class="footer-description">
                        <?php echo e($hostelSettings->description ?? 'Your home away from home. Experience comfort, safety, and community living.'); ?>

                    </p>
                    <?php if($hostelSettings->facebook || $hostelSettings->instagram || $hostelSettings->twitter): ?>
                    <div class="social-links">
                        <?php if($hostelSettings->facebook): ?>
                        <a href="<?php echo e($hostelSettings->facebook); ?>" target="_blank"><i class="ri-facebook-fill"></i></a>
                        <?php endif; ?>
                        <?php if($hostelSettings->instagram): ?>
                        <a href="<?php echo e($hostelSettings->instagram); ?>" target="_blank"><i class="ri-instagram-line"></i></a>
                        <?php endif; ?>
                        <?php if($hostelSettings->twitter): ?>
                        <a href="<?php echo e($hostelSettings->twitter); ?>" target="_blank"><i class="ri-twitter-x-line"></i></a>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="col-lg-4">
                    <h5 class="mb-4">Quick Links</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="#features" class="text-white-50 text-decoration-none">Features</a></li>
                        <li class="mb-2"><a href="#about" class="text-white-50 text-decoration-none">About Us</a></li>
                        <li class="mb-2"><a href="#contact" class="text-white-50 text-decoration-none">Contact</a></li>
                        <li class="mb-2"><a href="<?php echo e(route('admin.login')); ?>" class="text-white-50 text-decoration-none">Admin Login</a></li>
                    </ul>
                </div>
                <div class="col-lg-4">
                    <h5 class="mb-4">Contact Info</h5>
                    <ul class="list-unstyled text-white-50">
                        <?php if($hostelSettings->address): ?>
                        <li class="mb-2"><i class="ri-map-pin-line me-2"></i><?php echo e($hostelSettings->city ?? 'City'); ?>, <?php echo e($hostelSettings->state ?? 'State'); ?></li>
                        <?php endif; ?>
                        <?php if($hostelSettings->phone): ?>
                        <li class="mb-2"><i class="ri-phone-line me-2"></i><?php echo e($hostelSettings->phone); ?></li>
                        <?php endif; ?>
                        <?php if($hostelSettings->email): ?>
                        <li class="mb-2"><i class="ri-mail-line me-2"></i><?php echo e($hostelSettings->email); ?></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
            <div class="footer-bottom">
                <p class="mb-0">&copy; <?php echo e(date('Y')); ?> <?php echo e($hostelSettings->name ?? 'Gurudev Hostel'); ?>. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/js/helpers.js']); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/node-waves/node-waves.js']); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/js/bootstrap.js']); ?>
    
    <script>
        // Navbar scroll effect
        window.addEventListener('scroll', function() {
            const navbar = document.querySelector('.navbar-landing');
            if (window.scrollY > 50) {
                navbar.classList.add('scrolled');
            } else {
                navbar.classList.remove('scrolled');
            }
        });
        
        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });
        
        // Scroll to contact section if there are validation errors
        <?php if($errors->any()): ?>
            document.addEventListener('DOMContentLoaded', function() {
                const contactSection = document.getElementById('contact');
                if (contactSection) {
                    setTimeout(function() {
                        contactSection.scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    }, 100);
                }
            });
        <?php endif; ?>
        
        // Scroll to contact section on success
        <?php if(session('success')): ?>
            document.addEventListener('DOMContentLoaded', function() {
                const contactSection = document.getElementById('contact');
                if (contactSection) {
                    setTimeout(function() {
                        contactSection.scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    }, 100);
                }
            });
        <?php endif; ?>
        
        // Custom JS from Admin
        <?php if($websiteSettings->custom_js): ?>
        <?php echo $websiteSettings->custom_js; ?>

        <?php endif; ?>
    </script>
</body>
</html>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/GurudevHostel/resources/views/home.blade.php ENDPATH**/ ?>