// NOTICE: This file is generated by Rollup. To modify it,
// please instead edit the ESM counterpart and rebuild with Rollup (npm run build).
'use strict';

const postcss = require('postcss');
const typeGuards = require('./typeGuards.cjs');

/**
 * @param {Node} node
 * @returns {boolean}
 */
function isInDocument(node) {
	let current = node;

	while (current) {
		if (typeGuards.isDocument(current)) return true;

		// Check for unofficial 'document' property from parsers like postcss-html
		if ('document' in current && current.document instanceof postcss.Node && typeGuards.isDocument(current.document))
			return true;

		if (!current.parent) break;

		current = current.parent;
	}

	return false;
}

module.exports = isInDocument;
